clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% Costanti fisiche
T=293;          % Temperatura assoluta [K]
T0=273;         % Temperatura assoluta rif. [K]
mu=1.81e-5;     % viscosit` dinamica dell'aria a 0 C [Pas]
R=287.053;      % Costante dell'aria [J/Kg/K]
Pa=1e5;         % Pressione ambiente a 273 K [Pa]
Ps=6e5;         % Pressione alimentazione assoluta a 273 K [Pa]
b_c=0.5283;

Kt=sqrt(T/T0);
rho=Pa/(R*T);   % Densità dell'aria in condizioni normali [kg/m^3]
psi=0.6855/sqrt(R*T);
cost=1/(24*mu*R*T);
dt=1e-7;        % parametro per risolvere con Eulero esplicito
ck=60000/rho;   % per passare da kg/s a l/min

%% Geometria pattino
n_fori=4;       % numero di fori del pattino
dp=1e-3;        % diametro del foro di ingresso del pattino 
hg=30e-6;       % profondità media ragnatura
wg=0.2e-3;      % larghezza ragnatura
L=60e-3;
B=30e-3;
l=45e-3;
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
coeff=1;
A=L*B*coeff;            % Aumentando coeff gira più veloce (equivale ad aumentare il passo di tempo)
Vg=1*wg*hg*2*(l+b);     % volume ragnatura

%% parametri della valvola
dm=8e-3;                            % diametro membrana metallica m

% mettere i valori ottenuti dal Modello "0" di progetto
xn=     -3.0046e-06;
km=     3.9338e+05;      %area/pendenza

dn=0.95e-3;                      % diametro dell'ugello

d_con=5e-3;                         % diametro dei condotti interni al pattino
V_valvola=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;         % Volume della valvola
V_cond=pi*d_con^2/4*(60+30)*1e-3;   % volume dei condotti interni al pattino
V_cavo=pi*(4e-3)^2/4*20e-3;         % volume del tubo tra valvola e pattino
V1=V_valvola+V_cond+V_cavo;         % volume a monte del pattino
S_eqv=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

c_num=5e4;
%% Vettore delle Variabili Temporali
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cda1t=[];
   Cda2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t=[];
   H_dott=[];
   Xvt=[];
   G1t=[];
   G2t=[];
   G3t=[];
   Fmt=[];
   time=[];
   FFextt=[];

%% Inizializzazione pressioni, Reynolds
p1=Ps; % [Pa]
p2=Ps;
p0=Ps;
Re1=0;
Re2=0;

%% Punto iniziale per trovare le CONDIZIONI INIZIALI

h0=4*1e-6;
V0=h0*l*b;      % volume del meato
V2=V0+Vg;       % volume tot. = volume meato + volume ragnatura

Fp0=0;
g30=0;
err_Fp=10;
err_G=10;
x_bypass=13;   %    [um]
tic
j=0;
toll=1e-9;
while (abs(err_Fp)>toll || abs(err_G)>toll)
j=j+1;

% Calcolo la distanza ugello-membrana
x=xn+(p1-Pa)*(pi*dm^2/4)/km;
% Verifico se sono in condizioni di x_bypass o meno
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1]=FORO(C1,Ps,p1);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
g1=g1*Kt;
Re1=abs(g1)/(pi*mu*dn);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+2*wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             % portata attraverso un foro del pattino
g2=g2*Kt;
heq=(pi*h0*dp+2*hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

% Portate in uscita dal pattino
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);  

% Calcolo le pressioni p1, p0 e p2
p1=p1+(g1-g2*n_fori)*dt*R*T/V1;       % applico Eulero esplicito in avanti
p0=p0+(g2*n_fori-g3)*dt*R*T/V2;       % applico Eulero esplicito in avanti

af=0.14;
bf=5e-6;
f=1-af^(bf/h0);        % f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp=S_eqv*(p0-Pa);

% calcolo gli errori per uscire dal while
err_Fp=(Fp-Fp0)/Fp;
err_G=(g3-g30)/g3;
            
Fp0=Fp;
g30=g3;
end
    toc
%% Modello con forza in ingresso a gradino
i=0;
contatore=0;
F_EXT=[Fp:-20:10];

for i=1:length(F_EXT)

    g=9.806;
    h0_dot=0;   % condizione iniziale di velocità --> mi serve per Eulero esplicito in avanti
    err_Fp=10;
    err_G=10;
    err_h=10;
    F_ext=F_EXT(i);
    M(i)=F_ext/g;          % massa supportata dal pattino
    
    tic
while (abs(err_Fp)>toll || abs(err_h)>toll)
j=j+1;
contatore=contatore+1;

% Calcolo distanza ugello-membrana
x=xn+(p1-Pa)*(pi*dm^2/4)/km;
%Caso bypass
if x<x_bypass*1e-6
   x=x_bypass*1e-6;
end

% Conduttanza ugello valvola (si una la sezione anulare)
cda1=1.05*(1-0.3*exp(-0.005*Re1));
C1=cda1*(pi*x*dn)*Kt*psi;    %conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1]=FORO(C1,Ps,p1);      %portata attraverso l'ugello della valvola   (kg/s)
Re1=abs(g1)/(pi*mu*dn);

%Conduttanza foro pattino (si una la sezione anulare)
cda2=1.05*(1-0.3*exp(-0.005*Re2));
C2=cda2*(pi*h0*dp+2*wg*hg)*Kt*psi;   %conduttanza di un foro del pattino
[g2]=FORO(C2,p1,p2);             %portata attraverso un foro del pattino    (kg/s)
heq=(pi*h0*dp+2*hg*wg)/(pi*dp);
Re2=abs(g2)*h0/(pi*dp*mu*heq);

%Portate uscita meato
gx=cost*(h0)^3*((p0^2-Pa^2)/lx)*b;
gy=cost*(h0)^3*((p0^2-Pa^2)/ly)*l;
g3=2*(gx+gy);

%Calcolo forza e nuovo meato di equilibrio
Fp=S_eqv*(p0-Pa);
h1_dot=h0_dot+dt/M(i)*(Fp-F_ext-c_num*h0_dot);       % Eulero esplicito in avanti
h1=h0+h0_dot*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2=h0*l*b+Vg;
p1=p1+(g1-g2*n_fori)*dt*R*T/V1; % pattino attivo
p0=p0+((g2*n_fori-g3)-h0_dot*A*p0/(R*T))*dt*R*T/V2;
af=0.14;
bf=5e-6;
f=1-af^(bf/h0);    %f=p0/p2;
p2=(1/f)*(p0-Pa)+Pa;

% Calcolo gli errori per uscire dal while
err_Fp=(Fp-F_ext)/F_ext;
err_G=(g3-g30)/g3;
err_h=(h1-h0)/h0;

Fp0=Fp; 
g30=g3;
h0=h1;
h0_dot=h1_dot;
%% VARIABILI TEMPORALI (salvate ogni 2000 punti)
punti=2000;
if contatore==punti
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
   H0t=[H0t h0]; %(m)
   H_dott=[H_dott h0_dot]; %(m/s)
   Xvt=[Xvt x];
   G1t=[G1t g1*ck];
   G2t=[G2t g2*n_fori*ck];
   G3t=[G3t g3*ck];
   Fmt=[Fmt Fp];
   time=[time dt*j];
   FFextt=[FFextt F_ext];
   
   contatore=0;
end


end

toc
%% VARIABILI CORRISPONDENTI AI PUNTI DI EQUILIBRIO
%    %Reynolds Conduttanze 
%    RRe1(i)=Re1;
%    RRe2(i)=Re2;
%    Cda1(i)=cda1;
%    Cda2(i)=cda2;
%    Cs1(i)=C1;
%    Cs2(i)=C2;
% 
   %Pressioni
   P1(i)=p1;
   P2(i)=p2;
   P0(i)=p0;

%Caratteristiche pattino + valvola 
   H0(i)=h0*1e6;
   H_dot(i)=h0_dot;
   Xv(i)=x;
   G1(i)=g1*ck;
   G2(i)=g2*n_fori*ck;
   G3(i)=g3*ck;
   Fm(i)=Fp;

end


%% parametri della valvola
dm_2=8e-3;                            % diametro membrana metallica m

% mettere i valori ottenuti dal Modello "0" di progetto
xn_2=     -5.0e-06;
km_2=     3.60e+05;      %area/pendenza

dn_2=0.95e-3;                      % diametro dell'ugello

d_con_2=5e-3;                         % diametro dei condotti interni al pattino
V_valvola_2=(6e-3-3.75e-3)^2*pi/4*3.9e-3+(1.875e-3)^2*pi/4*(9)*1e-3;         % Volume della valvola
V_cond_2=pi*d_con_2^2/4*(60+30)*1e-3;   % volume dei condotti interni al pattino
V_cavo_2=pi*(4e-3)^2/4*20e-3;         % volume del tubo tra valvola e pattino
V1_2=V_valvola_2+V_cond_2+V_cavo_2;         % volume a monte del pattino
S_eqv_2=(l*b+L*B+0.5*(L*b+B*l))/3;        % superficie equivalente su cui insiste la Fp considerando una distribuz. di pressione a tronco di piramide

c_num_2=5e4;
%% Vettore delle Variabili Temporali
%Reynolds Conduttanze 
   RRe1t=[];
   RRe2t=[];
   Cda1t=[];
   Cda2t=[];
   Cs1t=[];
   Cs2t=[];
   %Pressioni
   P1t=[];
   P2t=[];
   P0t=[];
% Caratteristiche pattino + valvola 
   H0t_2=[];
   H_dott_2=[];
   Xvt_2=[];
   G1t_2=[];
   G2t_2=[];
   G3t_2=[];
   Fmt_2=[];
   time_2=[];
   FFextt_2=[];

%% Inizializzazione pressioni, Reynolds
p1_2=Ps; % [Pa]
p2_2=Ps;
p0_2=Ps;
Re1_2=0;
Re2_2=0;

%% Punto iniziale per trovare le CONDIZIONI INIZIALI

h0_2=4*1e-6;
V0_2=h0_2*l*b;      % volume del meato
V2_2=V0_2+Vg;       % volume tot. = volume meato + volume ragnatura

Fp0_2=0;
g30_2=0;
err_Fp_2=10;
err_G_2=10;
x_bypass_2=13;   %    [um]
tic
j_2=0;
toll_2=1e-9;
while (abs(err_Fp_2)>toll_2 || abs(err_G_2)>toll_2)
j_2=j_2+1;

% Calcolo la distanza ugello-membrana
x_2=xn_2+(p1_2-Pa)*(pi*dm_2^2/4)/km_2;
% Verifico se sono in condizioni di x_bypass o meno
if x_2<x_bypass_2*1e-6
   x_2=x_bypass_2*1e-6;
end

% Calcolo la conduttanza dell'ugello della valvola (considero la sezione ANULARE)
cda1_2=1.05*(1-0.3*exp(-0.005*Re1_2));
C1_2=cda1_2*(pi*x_2*dn_2)*Kt*psi;      % conduttanza dell'ugello della valvola con sezione ANULARE

% Calcolo la portata dell'ugello della valvola g1
[g1_2]=FORO(C1_2,Ps,p1_2);        % portata attraverso l'ugello della valvola calcolata con la function FORO 
g1_2=g1_2*Kt;
Re1_2=abs(g1_2)/(pi*mu*dn_2);

% Calcolo la conduttanza del foro del pattino (considero la sezione ANULARE)
cda2_2=1.05*(1-0.3*exp(-0.005*Re2_2));
C2_2=cda2_2*(pi*h0_2*dp+2*wg*hg)*Kt*psi;   % conduttanza di un foro del pattino
[g2_2]=FORO(C2_2,p1_2,p2_2);             % portata attraverso un foro del pattino
g2_2=g2_2*Kt;
heq_2=(pi*h0_2*dp+2*hg*wg)/(pi*dp);
Re2_2=abs(g2_2)*h0_2/(pi*dp*mu*heq_2);

% Portate in uscita dal pattino
gx_2=cost*(h0_2)^3*((p0_2^2-Pa^2)/lx)*b;
gy_2=cost*(h0_2)^3*((p0_2^2-Pa^2)/ly)*l;
g3_2=2*(gx_2+gy_2);  

% Calcolo le pressioni p1, p0 e p2
p1_2=p1_2+(g1_2-g2_2*n_fori)*dt*R*T/V1_2;       % applico Eulero esplicito in avanti
p0_2=p0_2+(g2_2*n_fori-g3_2)*dt*R*T/V2_2;       % applico Eulero esplicito in avanti

af_2=0.14;
bf_2=5e-6;
f_2=1-af_2^(bf_2/h0_2);        % f=p0/p2;
p2_2=(1/f_2)*(p0_2-Pa)+Pa;   % formula inversa per trovare p2

% Calcolo la forza di pressione Fp dovuta al meato
Fp_2=S_eqv_2*(p0_2-Pa);

% calcolo gli errori per uscire dal while
err_Fp_2=(Fp_2-Fp0_2)/Fp_2;
err_G_2=(g3_2-g30_2)/g3_2;
            
Fp0_2=Fp_2;
g30_2=g3_2;
end
    toc
%% Modello con forza in ingresso a gradino
i_2=0;
contatore_2=0;
F_EXT_2=[Fp_2:-20:10];

for i_2=1:length(F_EXT_2)

    g_2=9.806;
    h0_dot_2=0;   % condizione iniziale di velocità --> mi serve per Eulero esplicito in avanti
    err_Fp_2=10;
    err_G_2=10;
    err_h_2=10;
    F_ext_2=F_EXT_2(i_2);
    M_2(i_2)=F_ext_2/g_2;          % massa supportata dal pattino
    
    tic
while (abs(err_Fp_2)>toll_2 || abs(err_h_2)>toll_2)
j_2=j_2+1;
contatore_2=contatore_2+1;

% Calcolo distanza ugello-membrana
x_2=xn_2+(p1_2-Pa)*(pi*dm_2^2/4)/km_2;
%Caso bypass
if x_2<x_bypass_2*1e-6
   x_2=x_bypass_2*1e-6;
end

% Conduttanza ugello valvola (si una la sezione anulare)
cda1_2=1.05*(1-0.3*exp(-0.005*Re1_2));
C1_2=cda1_2*(pi*x_2*dn_2)*Kt*psi;    %conduttanza foro valvola con area anulare

%Calcolo portata ugello valvola
[g1_2]=FORO(C1_2,Ps,p1_2);      %portata attraverso l'ugello della valvola   (kg/s)
Re1_2=abs(g1_2)/(pi*mu*dn_2);

%Conduttanza foro pattino (si una la sezione anulare)
cda2_2=1.05*(1-0.3*exp(-0.005*Re2_2));
C2_2=cda2_2*(pi*h0_2*dp+2*wg*hg)*Kt*psi;   %conduttanza di un foro del pattino
[g2_2]=FORO(C2_2,p1_2,p2_2);             %portata attraverso un foro del pattino    (kg/s)
heq_2=(pi*h0_2*dp+2*hg*wg)/(pi*dp);
Re2_2=abs(g2_2)*h0_2/(pi*dp*mu*heq_2);

%Portate uscita meato
gx_2=cost*(h0_2)^3*((p0_2^2-Pa^2)/lx)*b;
gy_2=cost*(h0_2)^3*((p0_2^2-Pa^2)/ly)*l;
g3_2=2*(gx_2+gy_2);

%Calcolo forza e nuovo meato di equilibrio
Fp_2=S_eqv_2*(p0_2-Pa);
h1_dot_2=h0_dot_2+dt/M_2(i_2)*(Fp_2-F_ext_2-c_num_2*h0_dot_2);       % Eulero esplicito in avanti
h1_2=h0_2+h0_dot_2*dt;                     % Eulero esplicito in avanti

%Calcolo Pressioni
V2_2=h0_2*l*b+Vg;
p1_2=p1_2+(g1_2-g2_2*n_fori)*dt*R*T/V1_2; % pattino attivo
p0_2=p0_2+((g2_2*n_fori-g3_2)-h0_dot_2*A*p0_2/(R*T))*dt*R*T/V2_2;
af_2=0.14;
bf_2=5e-6;
f_2=1-af_2^(bf_2/h0_2);    %f=p0/p2;
p2_2=(1/f_2)*(p0_2-Pa)+Pa;

% Calcolo gli errori per uscire dal while
err_Fp_2=(Fp_2-F_ext_2)/F_ext_2;
err_G_2=(g3_2-g30_2)/g3_2;
err_h_2=(h1_2-h0_2)/h0_2;

Fp0_2=Fp_2; 
g30_2=g3_2;
h0_2=h1_2;
h0_dot_2=h1_dot_2;
%% VARIABILI TEMPORALI (salvate ogni 2000 punti)
punti_2=2000;
if contatore_2==punti_2
% %Reynolds Conduttanze 
%    RRe1t=[RRe1t Re1];
%    RRe2t=[RRe2t Re2];
%    Cda1t=[Cda1t cda1];
%    Cda2t=[Cda2t cda2];
%    Cs1t=[Cs1t C1];
%    Cs2t=[Cs2t C2];
%  %Pressioni
%    P1t=[P1t p1];
%    P2t=[P2t p2];
%    P0t=[P0t p0];
%Caratteristiche pattino + valvola 
   H0t_2=[H0t_2 h0_2]; %(m)
   H_dott_2=[H_dott_2 h0_dot_2]; %(m/s)
   Xvt_2=[Xvt_2 x_2];
   G1t_2=[G1t_2 g1_2*ck];
   G2t_2=[G2t_2 g2_2*n_fori*ck];
   G3t_2=[G3t_2 g3_2*ck];
   Fmt_2=[Fmt_2 Fp_2];
   time_2=[time_2 dt*j_2];
   FFextt_2=[FFextt_2 F_ext_2];
   
   contatore_2=0;
end


end

toc
%% VARIABILI CORRISPONDENTI AI PUNTI DI EQUILIBRIO
%    %Reynolds Conduttanze 
%    RRe1(i)=Re1;
%    RRe2(i)=Re2;
%    Cda1(i)=cda1;
%    Cda2(i)=cda2;
%    Cs1(i)=C1;
%    Cs2(i)=C2;
% 
   %Pressioni
   P1_2(i_2)=p1_2;
   P2_2(i_2)=p2_2;
   P0_2(i_2)=p0_2;

%Caratteristiche pattino + valvola 
   H0_2(i_2)=h0_2*1e6;
   H_dot_2(i_2)=h0_dot_2;
   Xv_2(i_2)=x_2;
   G1_2(i_2)=g1_2*ck;
   G2_2(i_2)=g2_2*n_fori*ck;
   G3_2(i_2)=g3_2*ck;
   Fm_2(i_2)=Fp_2;


end
%%
figure
plot(time,Fmt,'b','linewidth',2),grid on, hold on,
plot(time,FFextt,'r','linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),

figure
plot(time,H0t*1e6,'linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Air Gap  $ \quad h$ $(\mu m)$ '),

figure
plot(time,G3t*ck,'linewidth',2),grid on, hold on,
xlabel(' Time  $(s) $'),
ylabel(' Air Flow  $ \quad h$ $(\mu m)$ '),
%%

h_min=min(H0);
h_max=max(H0);
F_min=min(Fm);
F_max=max(Fm);

%% CAPACITA' DI CARICO
figure 
plot(H0,Fm,'b','linewidth',2),grid on, hold on,
plot(H0_2,Fm_2,'r','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Force  $ \quad F$ $(N)$ '),
grid on, zoom on
legend('Spessore vero','Spessore disponibile')
% xlim([1 35])

%% CONSUMO D'ARIA
figure 
plot(H0,G1,'b','linewidth',2),grid on, hold on,
plot(H0_2,G1_2,'r','linewidth',2),grid on, hold on,
xlabel(' Air \quad gap $\quad h$ $(\mu m) $'),
ylabel(' Air \quad Mass \quad Flow \quad Rate  \quad $Q$ $(\frac{l}{min} \quad ANR \quad 20^{\circ}$)'),
grid on, zoom on
legend('Spessore vero','Spessore disponibile')
% xlim([1 35])

%% PRESSIONE
figure 
plot(P1-Pa,Xv,'b','linewidth',2),grid on, hold on,
plot(P1_2-Pa,Xv_2,'r','linewidth',2),grid on, hold on,
xlabel('Pressione'),
ylabel('Spostamento membrana'),
legend('Spessore vero','Spessore disponibile')
grid on, zoom on
% xlim([5 35])
